<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\API\APIGeneralController;
use App\Models\EventCategory;
use App\Models\PodcastCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inertia\Inertia;
use App\Http\Controllers\Controller;
use App\Http\Requests\Account\UpdateCustomerGeneralInfoRequest;
use App\Http\Requests\Account\UpdateTherapistGeneralInfoRequest;
use App\Http\Requests\Account\UpdateTherapistCommunityGeneralInfoRequest;
use App\Http\Resources\Web\AppointmentTypesResource;
use App\Http\Resources\Web\ArchiveCategoriesResource;
use App\Http\Resources\Web\BlogCategoriesResource;
use App\Http\Resources\Web\TherapistCommunitysResource;
use App\Http\Resources\Web\TherapistCommunityMainCategoriesResource;
use App\Http\Resources\Web\CustomersResource;
use App\Http\Resources\Web\EventCategoriesResource;
use App\Http\Resources\Web\TherapistMainCategoriesResource;
use App\Http\Resources\Web\TherapistsResource;
use App\Http\Resources\Web\PodcastCategoriesResource;
use App\Http\Resources\Web\ServiceCategoriesResource;
use App\Http\Resources\Web\TagsResource;
use App\Models\AllLanguage;
use App\Models\AppointmentType;
use App\Models\ArchiveCategory;
use App\Models\BlogCategory;
use App\Models\TherapistCommunity;
use App\Models\TherapistCommunityCategory;
use App\Models\TherapistCommunityMainCategory;
use App\Models\City;
use App\Models\Country;
use App\Models\Customer;
use App\Models\Therapist;
use App\Models\TherapistCategory;
use App\Models\TherapistMainCategory;
use App\Models\Role;
use App\Models\ServiceCategory;
use App\Models\State;
use App\Models\Tag;

class AccountController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->middleware('verified');
    }
    public function showAccountPage(Request $request){
        $user = Auth::user();
        if($request->session()->get('logged_in_as') == 'therapist'){
            $therapist = $user->therapist;
            $therapist = Therapist::withChildrens()->withAll()->where('id',$therapist->id)->first();
            $therapist = new TherapistsResource($therapist);
            $therapist_categories = TherapistMainCategory::active()->whereHas('categories',function($q){
                $q->active();
            })->withAll()->withChildrens()->get();
            $therapist_categories = TherapistMainCategoriesResource::collection($therapist_categories);
            // $therapist_categories = TherapistCategory::active()->get();
            $blog_categories = BlogCategory::active()->get();
            $blog_categories = BlogCategoriesResource::collection($blog_categories);
            $event_categories = EventCategory::active()->get();
            $event_categories = EventCategoriesResource::collection($event_categories);
            $podcast_categories = PodcastCategory::active()->get();
            $podcast_categories = PodcastCategoriesResource::collection($podcast_categories);
            $service_categories = ServiceCategory::active()->get();
            $service_categories = ServiceCategoriesResource::collection($service_categories);
            $archive_categories = ArchiveCategory::active()->get();
            $archive_categories = ArchiveCategoriesResource::collection($archive_categories);
            $tags = Tag::active()->get();
            $tags = TagsResource::collection($tags);
            $countries = Country::active()->get();
            $states = State::active()->where('country_id',$therapist->country_id)->get();
            $cities = City::active()->where('state_id',$therapist->state_id)->get();
            $appointment_types = AppointmentType::active()->get();
            $appointment_types = AppointmentTypesResource::collection($appointment_types);
            $billing_states = State::active()->where('country_id',$therapist->billing_country_id)->get();
            $billing_cities = City::active()->where('state_id',$therapist->billing_state_id)->get();
            $shipping_states = State::active()->where('country_id',$therapist->shipping_country_id)->get();
            $shipping_cities = City::active()->where('state_id',$therapist->shipping_state_id)->get();
            $work_states = State::active()->where('country_id',$therapist->work_country_id)->get();
            $work_cities = City::active()->where('state_id',$therapist->work_state_id)->get();
            $languages = AllLanguage::active()->get();
            $data = [
                'therapist' => $therapist,
                'therapist_categories' => $therapist_categories,
                'blog_categories' => $blog_categories,
                'event_categories' => $event_categories,
                'podcast_categories' => $podcast_categories,
                'service_categories' => $service_categories,
                'archive_categories' => $archive_categories,
                'countries' => $countries,
                'states' => $states,
                'cities' => $cities,
                'tags' => $tags,
                'billing_states' => $billing_states,
                'billing_cities' => $billing_cities,
                'shipping_states' => $shipping_states,
                'shipping_cities' => $shipping_cities,
                'work_states' => $work_states,
                'work_cities' => $work_cities,
                'languages' => $languages,
                'appointment_types' => $appointment_types
            ];
        }
        if($request->session()->get('logged_in_as') == 'therapist_community'){
            $therapist_community = $user->therapist_community;
            $therapist_community = TherapistCommunity::withChildrens()->withAll()->where('id',$therapist_community->id)->first();
            $therapist_community = new TherapistCommunitysResource($therapist_community);
            $therapist_community_categories = TherapistCommunityMainCategory::active()->whereHas('categories',function($q){
                $q->active();
            })->withAll()->withChildrens()->get();
            $therapist_community_categories = TherapistCommunityMainCategoriesResource::collection($therapist_community_categories);
            $blog_categories = BlogCategory::active()->get();
            $blog_categories = BlogCategoriesResource::collection($blog_categories);
            $event_categories = EventCategory::active()->get();
            $event_categories = EventCategoriesResource::collection($event_categories);
            $podcast_categories = PodcastCategory::active()->get();
            $service_categories = ServiceCategory::active()->get();
            $service_categories = ServiceCategoriesResource::collection($service_categories);
            $podcast_categories = PodcastCategoriesResource::collection($podcast_categories);
            $archive_categories = ArchiveCategory::active()->get();
            $archive_categories = ArchiveCategoriesResource::collection($archive_categories);
            $tags = Tag::active()->get();
            $tags = TagsResource::collection($tags);
            $countries = Country::active()->get();
            $states = State::active()->where('country_id',$therapist_community->country_id)->get();
            $cities = City::active()->where('state_id',$therapist_community->state_id)->get();
            $billing_states = State::active()->where('country_id',$therapist_community->billing_country_id)->get();
            $billing_cities = City::active()->where('state_id',$therapist_community->billing_state_id)->get();
            $shipping_states = State::active()->where('country_id',$therapist_community->shipping_country_id)->get();
            $shipping_cities = City::active()->where('state_id',$therapist_community->shipping_state_id)->get();
            $work_states = State::active()->where('country_id',$therapist_community->work_country_id)->get();
            $work_cities = City::active()->where('state_id',$therapist_community->work_state_id)->get();
            $languages = AllLanguage::active()->get();
            $appointment_types = AppointmentType::active()->get();
            $appointment_types = AppointmentTypesResource::collection($appointment_types);
            $data = [
                'therapist_community' => $therapist_community,
                'therapist_community_categories' => $therapist_community_categories,
                'blog_categories' => $blog_categories,
                'event_categories' => $event_categories,
                'podcast_categories' => $podcast_categories,
                'service_categories' => $service_categories,
                'archive_categories' => $archive_categories,
                'countries' => $countries,
                'states' => $states,
                'cities' => $cities,
                'billing_states' => $billing_states,
                'billing_cities' => $billing_cities,
                'shipping_states' => $shipping_states,
                'shipping_cities' => $shipping_cities,
                'work_states' => $work_states,
                'work_cities' => $work_cities,
                'tags' => $tags,
                'languages' => $languages,
                'appointment_types' => $appointment_types
            ];
        }
        if($request->session()->get('logged_in_as') == 'customer'){
            $customer = $user->customer;
            $customer = Customer::withChildrens()->withAll()->where('id',$customer->id)->first();
            $customer = new CustomersResource($customer);
            $countries = Country::active()->get();
            $states = State::active()->where('country_id',$customer->country_id)->get();
            $cities = City::active()->where('state_id',$customer->state_id)->get();
            $data = [
                'customer' => $customer,
                'countries' => $countries,
                'states' => $states,
                'cities' => $cities,
            ];
        }

        return Inertia::render('Account',$data);
    }

    public function updateCustomerGeneralInformation(UpdateCustomerGeneralInfoRequest $request)
    {
        $user = auth()->user();
        $customer = $user->customer;
        if($customer){
            $customer->update($request->only(['first_name','last_name','user_name','description','country_id','state_id','city_id','address_line_1','address_line_2','zip_code']));
            $image = uploadCroppedFile($request,'image','profile_images',$customer->image);
            $cover_image = uploadCroppedFile($request,'cover_image','cover_images',$customer->cover_images);
            $customer->update(['image' => $image]);
            $customer->update(['cover_image' => $cover_image]);
        }
        request()->session()->flash('alert', [
            'type' => 'success',
            'message' => 'Profile Updated Successfully',
        ]);
        return redirect()->back()->withResponseData([
            'message' => 'Profile Updated Successfully',
            'type' => 'success'
        ]);
    }

    public function updateTherapistGeneralInformation(UpdateTherapistGeneralInfoRequest $request)
    {
        $user = auth()->user();
        $therapist = $user->therapist;
        if($therapist){
            $therapist->update($request->only(['first_name','last_name','description','country_id','state_id','city_id','experience','speciality','address_line_1','address_line_2','longitude','latitude','zip_code','user_name','is_energy_exchange','is_co_creation',
            'prefix','suffix','home_phone','cell_phone','job_title','company','website','email',
            'billing_address_line_1','billing_address_line_2','billing_country_id', 'billing_state_id', 'billing_city_id','billing_zip_code',
            'shipping_address_line_1','shipping_address_line_2','shipping_country_id', 'shipping_state_id', 'shipping_city_id','shipping_zip_code',
            'work_address_line_1','work_address_line_2','work_country_id', 'work_state_id', 'work_city_id','work_zip_code']));
            $image = uploadCroppedFile($request,'image','profile_images',$therapist->image);
            $cover_image = uploadCroppedFile($request,'cover_image','cover_images',$therapist->cover_images);
            $therapist->update(['image' => $image]);
            $therapist->update(['cover_image' => $cover_image]);
            $therapist->therapist_categories()->sync($request->therapist_categories);
            $therapist->languages()->sync($request->languages);
            $therapist->tags()->sync($request->tags);
        }
        // $this->updateUserProifleCompletion('healer');

        request()->session()->flash('alert', [
            'type' => 'success',
            'message' => 'Profile Updated Successfully',
        ]);
        return redirect()->back()->withResponseData([
            'message' => 'Profile Updated Successfully',
            'type' => 'success'
        ]);
    }

    public function updateTherapistSettings(Request $request){
        $user = Auth::user();
        $therapist = $user->therapist;
        foreach($request->settings as $setting){
            $therapist->therapist_settings()->updateOrCreate(['name' => $setting['name']],$setting);
        }
        request()->session()->flash('alert', [
            'type' => 'success',
            'message' => 'Settings Updated Successfully',
        ]);
        return redirect()->back()->withResponseData([
            'message' => 'Settings Updated Successfully',
            'type' => 'success'
        ]);
    }

    public function updateTherapistCommunityGeneralInformation(UpdateTherapistCommunityGeneralInfoRequest $request)
    {
        $user = auth()->user();
        $therapist_community = $user->therapist_community;
        if($therapist_community){
            $therapist_community->update($request->only(['therapist_community_name','therapist_community_website','first_name','last_name','description','country_id','state_id','city_id','address_line_1','address_line_2','zip_code','user_name','longitude','latitude','prefix','suffix','home_phone','cell_phone','job_title','company','website','email',
            'billing_address_line_1','billing_address_line_2','billing_country_id', 'billing_state_id', 'billing_city_id','billing_zip_code',
            'shipping_address_line_1','shipping_address_line_2','shipping_country_id', 'shipping_state_id', 'shipping_city_id','shipping_zip_code',
            'work_address_line_1','work_address_line_2','work_country_id', 'work_state_id', 'work_city_id','work_zip_code']));
            $image = uploadCroppedFile($request,'image','profile_images',$therapist_community->image);
            $cover_image = uploadCroppedFile($request,'cover_image','cover_images',$therapist_community->cover_image);

            $therapist_community->update(['image' => $image]);
            $therapist_community->update(['cover_image' => $cover_image]);

            $therapist_community->therapist_community_categories()->sync($request->therapist_community_categories);
            $therapist_community->languages()->sync($request->languages);
            $therapist_community->tags()->sync($request->tags);
        }
        request()->session()->flash('alert', [
            'type' => 'success',
            'message' => 'Profile Updated Successfully',
        ]);
        return redirect()->back()->withResponseData([
            'message' => 'Profile Updated Successfully',
            'type' => 'success'
        ]);
    }

    public function updateTherapistCommunitySettings(Request $request){
        $user = Auth::user();
        $therapist_community = $user->therapist_community;
        foreach($request->settings as $setting){
            $therapist_community->therapist_community_settings()->updateOrCreate(['name' => $setting['name']],$setting);
        }
        request()->session()->flash('alert', [
            'type' => 'success',
            'message' => 'Settings Updated Successfully',
        ]);
        return redirect()->back()->withResponseData([
            'message' => 'Settings Updated Successfully',
            'type' => 'success'
        ]);
    }

    public function becomeTherapist(Request $request){
        $user = Auth::user();
        $logged_in_as = $request->session()->get('logged_in_as');
        $data = $user->{$logged_in_as};
        $pricing_plan = getTherapistDefaultPricingPlan();

        if(!$user->hasRole(Role::$Therapist)){
            $user->roles()->attach([Role::$Therapist]);
            $user->therapist()->create([
                'first_name' => $data->first_name,
                'last_name' => $data->last_name,
                'description' => $data->description,
                'country_id' => $data->country_id,
                'state_id' => $data->state_id,
                'city_id' => $data->city_id,
                'address_line_1' => $data->address_line_1,
                'address_line_2' => $data->address_line_2,
                'zip_code' => $data->zip_code,
                'pricing_plan_id' => $pricing_plan->id ?? null
            ]);
        }
        // $request->session()->put('logged_in_as', Role::$Therapist);
        // request()->session()->flash('alert', [
        //     'type' => 'success',
        //     'message' => 'Successfully Switched To '.ucfirst(Role::$Therapist),
        // ]);
        request()->session()->flash('alert', [
            'type' => 'success',
            'message' => 'Now, You Are A Therapist Also',
        ]);
        return redirect()->back();
    }
    public function becomeUser(Request $request){
        $user = Auth::user();
        $logged_in_as = $request->session()->get('logged_in_as');
        $data = $user->{$logged_in_as};
        if(!$user->hasRole(Role::$Customer)){
            $user->roles()->attach([Role::$Customer]);
            $user->customer()->create([
                'first_name' => $data->first_name,
                'last_name' => $data->last_name,
                'description' => $data->description,
                'country_id' => $data->country_id,
                'state_id' => $data->state_id,
                'city_id' => $data->city_id,
                'address_line_1' => $data->address_line_1,
                'address_line_2' => $data->address_line_2,
                'zip_code' => $data->zip_code,

            ]);
        }
        // $request->session()->put('logged_in_as', Role::$Customer);
        // request()->session()->flash('alert', [
        //     'type' => 'success',
        //     'message' => 'Successfully Switched To '.ucfirst(Role::$Customer),
        // ]);
        request()->session()->flash('alert', [
            'type' => 'success',
            'message' => 'Now, You Are A Customer Also',
        ]);
        return redirect()->back();
    }
    public function becomeTherapistCommunity(Request $request){
        $user = Auth::user();
        $logged_in_as = $request->session()->get('logged_in_as');
        $data = $user->{$logged_in_as};
        $pricing_plan = getTherapistCommunityDefaultPricingPlan();
        if(!$user->hasRole(Role::$TherapistCommunity)){
            $user->roles()->attach([Role::$TherapistCommunity]);
            $user->therapist_community()->create([
                'first_name' => $data->first_name,
                'last_name' => $data->last_name,
                'description' => $data->description,
                'country_id' => $data->country_id,
                'state_id' => $data->state_id,
                'city_id' => $data->city_id,
                'address_line_1' => $data->address_line_1,
                'address_line_2' => $data->address_line_2,
                'zip_code' => $data->zip_code,
                'pricing_plan_id' => $pricing_plan->id ?? null
            ]);
        }
        // $request->session()->put('logged_in_as', Role::$TherapistCommunity);
        // request()->session()->flash('alert', [
        //     'type' => 'success',
        //     'message' => 'Successfully Switched To '.ucfirst(Role::$TherapistCommunity),
        // ]);
        request()->session()->flash('alert', [
            'type' => 'success',
            'message' => 'Now, You Are A TherapistCommunity User Also',
        ]);
        return redirect()->back();
    }
    public function switchRole(Request $request,$role){
        $user = Auth::user();
        $logged_in_as = $request->session()->get('logged_in_as');
        $data = $user->{$logged_in_as};
        if($user->hasRole($role)){
            if(isset($data)){
                $data->update(['is_online' => 0]);
            }
            if(isset($user->{$role})){
                $user->{$role}->update(['is_online' => 1]);
            }
            $request->session()->put('logged_in_as', $role);
        }
        request()->session()->flash('alert', [
            'type' => 'success',
            'message' => 'Successfully Switched To '.ucfirst($role),
        ]);
        return redirect()->back();
    }

    public function getStates(Request $request){
        $request->validate(['country_id' => 'exists:countries,id']);
        $states = APIGeneralController::getStates($request);
        $response = generateResponse($states,true,"States Fetched Successfully",null,'collection');
        return response()->json($response);
    }

    public function getCities(Request $request){
        $request->validate(['city_id' => 'exists:cities,id']);
        $cities = APIGeneralController::getCities($request);
        $response = generateResponse($cities,true,"Cities Fetched Successfully",null,'collection');
        return response()->json($response);
    }
}
